#ifndef __C4DSTRING_H
#define __C4DSTRING_H

#include "operatingsystem.h"

#ifdef __MAC
#include <size_t.h>
#if defined(__cplusplus) && defined(_MSL_USING_NAMESPACE)
	using namespace std;
#endif
#endif

class String
{
	private:
		CHAR priv[16]; // fixed size of 16 bytes
	public:

		void* operator new(size_t,int line,const CHAR *file);
		void  operator delete(void *del);

		void* operator new(size_t,void *place) { return place; }
		void  operator delete(void*, void*) {}

		String(void);
		String(const String &Str);
		String(const CHAR *cstr);
		String(LONG Count,UWORD FillCh);
		~String(void);

		void CopyTo(String *dst) const;
		String *GetClone(void) const;

		LONG GetLength(void) const;			
		Bool Content(void) const { return GetLength()!=0; }

		const String& operator = (const String &Str);

		friend const String operator +  (const String &Str1,const String &Str2);
		const String& operator += (const String &Str);

		Bool operator <  (const String &Str) const;
		Bool operator >  (const String &Str) const;
		Bool operator <= (const String &Str) const;
		Bool operator >= (const String &Str) const;
		Bool operator == (const String &Str) const;
		Bool operator != (const String &Str) const;

		// 0 == , <0 < , >0 >
		LONG Compare   (const String &Str) const;
		LONG LexCompare(const String &Str) const;
		LONG RelCompare(const String &Str) const;

		Bool FindFirst(const String &Str, LONG *Pos, LONG Start= 0) const;
		Bool FindLast (const String &Str, LONG *Pos, LONG Start=-1) const;
		Bool FindFirst(UWORD ch, LONG *Pos, LONG Start= 0) const;
		Bool FindLast (UWORD ch, LONG *Pos, LONG Start=-1) const;

		void Delete(LONG Pos,LONG Count);
		void Insert(LONG Pos, const String &Str);
		void Insert(LONG Pos, UWORD Ch);

		const String SubStr(LONG Start, LONG Count) const;

		Real StringToReal(LONG *error=NULL, LONG unit=0, LONG angletype=0, LONG base=10) const;
		LONG StringToLong(LONG *error=NULL) const;

		friend const String RealToString(Real v, LONG vk=-1, LONG nk=-1, Bool e=FALSE, UWORD xchar='0');
		friend const String LongToString(LONG l);
			
		const String ToUpper(void) const;
		const String ToLower(void) const;
		
		LONG GetCStringLen(StringEncoding Type=StXbit) const;													// Liefert die Laenge des zu erwartenden CStrings
		LONG GetCString(CHAR *Cstr, LONG Max, StringEncoding Type=StXbit) const;			// Max gibt die maximale Anzahl der CHARs an
		LONG SetCString(const CHAR *Cstr, LONG Count=-1, StringEncoding Type=StXbit);	// Count gibt die Anzahl der CHARs an, bzw. -1 bis zur 0

		class PChar
		{
			friend class String;
			
			private:
				PChar(String *str,LONG pos);
				
			public:
				PChar& operator = (const PChar& rhs);
				PChar& operator = (UWORD c);
				operator UWORD() const;
				
			private:
				String *Str;
				LONG Pos;
		};
		
		const PChar operator[] (LONG Pos) const;
		PChar operator[] (LONG Pos);
};

const String LongToString(LONG l);
const String RealToString(Real v, LONG vvk, LONG nnk, Bool e, UWORD xchar);

void FreeString(String *&str);

#endif
